-- IGNORE ON DB-CREATE IF EXISTS USER 'root' : DB-Erstellung im Prodat überspringt diese Datei (TDBCreateForm.btReloadXXXClick)

-- Wiki: CREATE USER        https://www.postgresql.org/docs/current/static/sql-createrole.html
-- externes Wiki            http://redmine.prodat-sql.de/projects/prodat-v12-public/wiki/Benutzer-_und_Benutzergruppen
-- intern inkl. extern      http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/System-Benuter_und_-Benutzergruppen
--
-- Passwörter               https://redmine.prodat-sql.de/projects/prodat-v-x/keys
-- Passwort verschlüsseln   siehe Wiki : intern inkl. extern > Passwort verschlüsseln = SELECT 'md5' || md5(:password || :rolename)



/* Benutzer in Benutzergruppe */

-- siehe Kommentare in "PSQL\0050 System\ZZ Groups.sql"
--ALTER GROUP &groname ADD USER &usename
--ALTER GROUP &groname DROP USER &usename

CREATE OR REPLACE FUNCTION TSystem.create__user(_user VARCHAR, _params VARCHAR) RETURNS void AS $$
  BEGIN
    IF NOT EXISTS (SELECT true FROM pg_catalog.pg_roles WHERE rolname = _user) THEN
      EXECUTE concat('CREATE USER ', quote_ident(_user), ' ', _params, ';');
    END IF;
    RETURN;
  END $$ LANGUAGE plpgsql;

-- SUPERUSER

    /* Administratoren */
    ALTER  USER "postgres" ENCRYPTED PASSWORD 'md5eee95864208f91e4b544fde00c64d2b6';                                              -- System-Admin
    SELECT TSystem.create__user('root',     $$ ENCRYPTED PASSWORD 'md5c967bfcb26b29b2a89a5eef12b0d2702' SUPERUSER CREATEDB $$);   -- Administrator
    SELECT TSystem.create__user('SYS.dblink',   $$ ENCRYPTED PASSWORD 'md587fc8a43c07a4fee7105846ffda6ef10' SUPERUSER $$);        --- #22475



    -- Dienst/APPS
    SELECT TSystem.create__user('APPS',     $$ ENCRYPTED PASSWORD 'md5cae8ace8b25d2d24bcb5781d19767bec' SUPERUSER $$ );           -- wegen zB DailyDBFunctions Superuser. TCache.CachedViews_Refresh() > pg_terminate_backend

-- SUPERUSER ENDE

SELECT TSystem.create__user('syncro',     $$ ENCRYPTED PASSWORD 'md5e54534382c7ca5ea4ce9c745565325d5'$$ );                        -- Nutzer zum Syncronisieren.
SELECT TSystem.create__user('grafana',    $$ ENCRYPTED PASSWORD 'md526de99c684895c7377d3d30cdcf92349'$$ );                        -- grafana

SELECT TSystem.create__user('SYS.tools',  $$ ENCRYPTED PASSWORD 'md5eacd4ae90e31a484eb44682528045526'$$ );                        -- LieferscheinScan und sonstige kleine Module von Extern


-- BDE und LLV
SELECT TSystem.create__user('BDE',      $$ ENCRYPTED PASSWORD 'md5e3ab6d8602f111547e1fc860aee98459'$$ );                          -- Nutzer zum Anstempeln von BDE
SELECT TSystem.create__user('BDE-USER', $$ ENCRYPTED PASSWORD 'md5eb99b32cfb14ead17bf589e25085443d'$$ );                          -- Nutzer zum Stempeln und bearbeiten von BDE


--  BEACHTE CREATE ROLE "FREDA_NFCLOGIN" WITH !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

DO $$
  DECLARE rec RECORD;
  BEGIN

    FOR rec IN SELECT * FROM pg_user -- WHERE usename NOT IN ( 'GEO' )  -- 'DSCHUCH'
    LOOP
        RAISE NOTICE '%', rec.usename;
        EXECUTE 'GRANT "SYS.Prodat-User" TO "' || rec.usename || '";';
    END LOOP;
END $$;

SELECT TSystem.grant__table_funktion_sequence_schema_privileg__to__rolle('SYS.Prodat-User');


/* DEMO-Datenbank */

-- siehe "PSQL\9700 Demodaten\DemoDaten.0000.DemoUser.sql"
--CREATE USER "DEMO"     ENCRYPTED PASSWORD '...' NOSUPERUSER NOCREATEDB;                      -- Testbenutzer für DEMO-Datenbank "PSQL\9700 Demodaten\*"
--CREATE USER "DEMODATA" NOLOGIN NOSUPERUSER NOCREATEDB;                                       -- Testbenutzer zum Anlegen der DEMO-Daten (ohne Login > SET SESSION AUTHORIZATION)

--CREATE USER "CIMPCS"   SUPERUSER CREATEDB;                                                   -- CIMPCS-Entwicklerlogins
--CREATE USER "987"      SUPERUSER CREATEDB;                                                   --
--CREATE USER "AKU"      SUPERUSER CREATEDB;                                                   --
--...



/* DMS */

--CREATE USER "DMS-SYNC-USER" ENCRYPTED PASSWORD '...';                                          -- Zugriff für externes DMS

/*CREATE USER "ELO" ENCRYPTED PASSWORD 'md5d0767a375f516b8c7f58f13aab1df5f2' NOSUPERUSER NOINHERIT;   -- Zugriff für externes DMS (ELO)
    --GRANT CONNECT ON DATABASE current_database() TO "ELO";

    GRANT SELECT ON TDMS.External_DMS__get_Documents               TO "ELO";
    GRANT SELECT ON FUNCTION TDMS.External_DMS__get_Keywords       TO "ELO";
    --ANT SELECT ON FUNCTION TDMS.External_DMS__set_Keyword        TO "ELO";
    GRANT SELECT ON FUNCTION TDMS.External_DMS__get_RemoteFilename TO "ELO";
    GRANT SELECT ON FUNCTION TDMS.External_DMS__set_ID             TO "ELO";
    GRANT SELECT ON FUNCTION TDMS.External_DMS__reset_Updated      TO "ELO";
    GRANT SELECT ON FUNCTION TDMS.External_DMS__adk                TO "ELO";
    GRANT SELECT ON FUNCTION TDMS.picndoku__fetch__metadata        TO "ELO";

    -- Benutzer wieder löschen:
    --REVOKE ALL ON SCHEMA TDMS FROM "ELO";   -- Berechtigungen löschen
    --REASSIGN OWNED BY "ELO" TO "root";      -- Abhängigkeiten auflösen (muss je Datenbank ausgeführt werden)
    --DROP ROLE IF EXISTS "ELO";              -- weg damit
--*/



/* PRODAT-Runtime */

-- im PRODAT > Personalmanagement > Mitarbeiterverzeichnis
-- Trigger "llv__b_iu" > IF ll_db_login THEN   CREATE/ALTER/DROP USER
--CREATE USER &coalesce(ll_db_usename,ll_minr) ENCRYPTED PASSWORD &coalesce(ll_passwd,lower(ll_db_usename)) SUPERUSER;
--ALTER USER &old.ll_db_usename RENAME TO &new.ll_db_usename;
--ALTER USER &ll_db_usename ENCRYPTED PASSWORD &ll_passwd;
--REASSIGN OWNED BY &ll_db_usename TO "root";   DROP USER &ll_db_usename;


-- im PRODAT > Systemprogramme > Konfiguration > Benutzerverwaltung > Benutzerverwaltung
-- TFormAddUser.CimButton1Click / TFormUsers.ServSql1UsersBeforeInsert und TFormUsers.ServSql1UsersBeforeDelete
--CREATE USER &username ENCRYPTED PASSWORD &passwd SUPERUSER CREATEDB;
--   Auskommentiert: CREATE USER &username ENCRYPTED PASSWORD &passwd &rights;  -- rights=CREATEROLE wenn chkCanCreateUsers.Checked
--DROP USER &username;

-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT true;

